<?php

if( !class_exists( 'PostmanEmailLogs' ) ) {

    require_once POST_SMTP_PATH . '/Postman/PostmanEmailLogs.php';

}


/**
 * Adds a meta field to the given log.
 * 
 * @since 2.5.0
 * @version 1.0.0
 */
if( !function_exists( 'postman_add_log_meta' ) ):
function postman_add_log_meta( $log_id, $meta_key, $meta_value ) {

    global $wpdb;
    $email_logs =  new PostmanEmailLogs();

    return $wpdb->insert(
        $wpdb->prefix . $email_logs->meta_table,
        array(
            'log_id'        =>  $log_id,
            'meta_key'      =>  $meta_key,
            'meta_value'    =>  $meta_value
        ),
        array(
            '%d',
            '%s',
            '%s'
        )
    );

}
endif;


/**
 * Updates a log meta field based on the given log ID.
 * 
 * @since 2.5.0
 * @version 1.0.0
 */
if( !function_exists( 'postman_update_log_meta' ) ):
function postman_update_log_meta( $log_id, $meta_key, $meta_value ) {

    global $wpdb;
    $email_logs = new PostmanEmailLogs();

    return $wpdb->update(
        $wpdb->prefix . $email_logs->meta_table,
        array(
            'meta_value'    =>  $meta_value
        ),
        array(
            'log_id'        =>  $log_id,
            'meta_key'      =>  $meta_key
        ),
        array(
            '%s'
        ),
        array(
            '%d',
            '%s'
        )
    );

}
endif;


/**
 * Retrieves a log meta field for the given log ID.
 * 
 * @since 2.5.0
 * @version 1.0.0
 */
if( !function_exists( 'postman_get_log_meta' ) ):
function postman_get_log_meta( $log_id, $key = '' ) {

    global $wpdb;
    $email_logs = new PostmanEmailLogs();

    if( empty( $key ) ) {

        return $wpdb->get_results(
            $wpdb->prepare(
                "SELECT `meta_key`, `meta_value` FROM {$wpdb->prefix}{$email_logs->meta_table}
                WHERE `log_id` = %d",
                $log_id
            )
        );

    }

    return $wpdb->get_row(
        $wpdb->prepare(
            "SELECT `meta_value` FROM {$wpdb->prefix}{$email_logs->meta_table}
            WHERE `log_id` = %d && `meta_key` = %s",
            $log_id,
            $key
        )
    ); 

}
endif;


/**
 * Deletes a log meta field for the given log ID.
 * 
 * @since 2.5.0
 * @version 1.0.0
 */
if( !function_exists( 'postman_delete_log_meta' ) ):
function postman_delete_log_meta( $log_id, $meta_key, $meta_value = '' ) {

    global $wpdb;
    $email_logs = new PostmanEmailLogs();

    $where = array(
        'log_id'    =>  $log_id,
        'meta_key'  =>  $meta_key
    );

    $where_format = array(
        '%d',
        '%s'
    );

    if( !empty( $meta_value ) ) {

        $where['meta_value'] = $meta_value;
        $where_format[] = '%s';

    }

    return $wpdb->delete(
        $wpdb->prefix . $email_logs->meta_table,
        $where,
        $where_format
    );

}
endif;